
/************************************************************************
 *
 * \file: aautoDemoIControllerCallbacks.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Prototype
 *
 * \author: D. Girnus / ADIT/SW1/Brunel / dgirnus@de.adit-jv.com
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/


/* *************  includes  ************* */

#include "aautoDemoIControllerCallbacks.h"
#include "utils/EventDispatcher.h"
#include "Server.h"
#include "AutoSmoketest.h"
#include "Testbed.h"

#include <inttypes.h>

/* *************  locals  ************* */

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

/* *************  functions  ************* */

void AautoDemoIControllerCallbacks::serviceDiscoveryRequestCallback(const std::string& smallIcon,
        const std::string& mediumIcon, const std::string& largeIcon, const std::string& label, const std::string& deviceName) {

    LOG_INFO((demo, "%s() deviceName=%s triggered", __FUNCTION__, deviceName.c_str()));
    AutoSmoketest::instance().setTestError(AAPSTARTED);

    if(Testbed::instance().getTestbedMode())
    {
        Testbed::instance().adit_testbed_available();
    }
}

void AautoDemoIControllerCallbacks::unrecoverableErrorCallback(MessageStatus err) {
    LOG_ERROR((demo, "%s() Encountered unrecoverable error = %d. Shutting down", __FUNCTION__, err));
}

void AautoDemoIControllerCallbacks::pingRequestCallback(int64_t timestamp, bool bugReport) {
    LOG_INFO((demo, "%s()  timestamp = %" PRId64 ", bugReport = %d", __FUNCTION__, timestamp, bugReport));
}

void AautoDemoIControllerCallbacks::pingResponseCallback(int64_t timestamp) {
    LOG_INFO((demo, "%s()  timestamp = %" PRId64 "", __FUNCTION__, timestamp));
}

void AautoDemoIControllerCallbacks::navigationFocusCallback(NavFocusType focusType) {

    LOG_INFO((demo, "%s()  focusType = %d", __FUNCTION__, focusType));
    // If you plan to run your on-board turn by turn nav while also running GAL,
    // you should get in touch with the GAL team to discuss what you are doing.
    mGalReceiver->setNavigationFocus(focusType);
}

void AautoDemoIControllerCallbacks::byeByeRequestCallback(ByeByeReason reason) {
    LOG_INFO((demo, "%s() ByeByeReason = %d from device %s", __FUNCTION__, reason, mSerial.c_str()));
    std::shared_ptr<DevEventItem> mEvent (new DevEventItem(DevEventType::ByeByeRequest,mSerial ));
    Server::instance().queueEvent(mEvent);
}

void AautoDemoIControllerCallbacks::byeByeResponseCallback() {
    LOG_INFO((demo, "%s() byeByeResponse", __FUNCTION__));
    mRecvByeByeResponse = true;
}

void AautoDemoIControllerCallbacks::voiceSessionNotificationCallback(VoiceSessionStatus status) {
    // If you plan to run your on-board voice recognizer while also running GAL,
    // you should get in touch with the GAL team to discuss what you are doing.
    LOG_INFO((demo, "%s() Voice session notification, status = %d", __FUNCTION__, status));
}

void AautoDemoIControllerCallbacks::audioFocusRequestCallback(AudioFocusRequestType request) {
    switch (request) {
        case AUDIO_FOCUS_GAIN:
            mGalReceiver->setAudioFocus(AUDIO_FOCUS_STATE_GAIN, false);
            LOG_INFO((demo, "%s() Granted audio focus", __FUNCTION__));
            break;
        case AUDIO_FOCUS_GAIN_TRANSIENT:
            mGalReceiver->setAudioFocus(AUDIO_FOCUS_STATE_GAIN_TRANSIENT, false);
            LOG_INFO((demo, "%s() Granted transient audio focus", __FUNCTION__));
            break;
        case AUDIO_FOCUS_GAIN_TRANSIENT_MAY_DUCK:
            mGalReceiver->setAudioFocus(AUDIO_FOCUS_STATE_GAIN_TRANSIENT, false);
            LOG_INFO((demo, "%s() Granted transient may duck audio focus", __FUNCTION__));
            break;
        case AUDIO_FOCUS_RELEASE:
            mGalReceiver->setAudioFocus(AUDIO_FOCUS_STATE_LOSS, false);
            LOG_INFO((demo, "%s() Released audio focus", __FUNCTION__));
            break;
        default:
            LOG_ERROR((demo, "%s() Unknown audio focus request type. Ignoring.", __FUNCTION__));
            break;
    }
}

void AautoDemoIControllerCallbacks::notifyStatusCallback(GalReceiverTransportStatus inStatus)
{
    LOG_WARN((demo, "AautoDemoIControllerCallbacks::notifyStatusCallback: %d", (int)inStatus));
}

} } /* namespace adit { namespace aauto { */

